//
// Created by root on 9/28/25.
//

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <iostream>
#include <string>
#include <memory>
#include <cstring>
#include <map>
#include <thread>
#include <sys/socket.h>
#include <netinet/in.h>
#include <vector>
#include <dlfcn.h>
#include <stdint.h>
#include <sys/mman.h>
#include "signal.h"

extern "C" {
#include "sai.h"
}

std::vector<std::pair<sai_fdb_entry_t, sai_object_id_t> > gFdbMap;
std::map<std::string, std::string> gProfileMap;
std::map<std::string, std::string>::iterator gProfileIter = gProfileMap.begin();

void on_switch_state_change(sai_object_id_t switch_id, sai_switch_oper_status_t switch_oper_status) {
}

void on_port_state_change(uint32_t count, sai_port_oper_status_notification_t *data) {
}

void on_shutdown_request(sai_object_id_t switch_id) {
}

void on_fdb_event(uint32_t count, sai_fdb_event_notification_data_t *data) {
}

const char *profile_get(sai_switch_profile_id_t profile_id, const char *variable) {
    if (variable == NULL) {
        return NULL;
    }
    std::map<std::string, std::string>::const_iterator it = gProfileMap.find(variable);
    if (it == gProfileMap.end()) {
        return NULL;
    }

    return it->second.c_str();
}

int profile_get_next(sai_switch_profile_id_t profile_id, const char **variable, const char **value) {
    if (value == NULL) {
        gProfileIter = gProfileMap.begin();
        return 0;
    }
    if (variable == NULL) {
        return -1;
    }
    if (gProfileIter == gProfileMap.end()) {
        return -1;
    }
    *variable = gProfileIter->first.c_str();
    *value = gProfileIter->second.c_str();
    gProfileIter++;
    return 0;
}

const sai_service_method_table_t services = {
    profile_get,
    profile_get_next
};

void boot() {
    gProfileMap["SAI_INIT_CONFIG_FILE"] = "config.bcm";
    //Broadcom config file must be in same directory, or change path here

    auto status = sai_api_initialize(0, (sai_service_method_table_t *) &services);

    constexpr std::uint32_t attrSz = 6;
    sai_attribute_t attr[attrSz];
    std::memset(attr, '\0', sizeof(attr));

    attr[0].id = SAI_SWITCH_ATTR_INIT_SWITCH;
    attr[0].value.booldata = true;

    sai_mac_t mac = {0x11, 0x22, 0x33, 0x44, 0x55, 0x66}; //Switch's L2 source address

    attr[1].id = SAI_SWITCH_ATTR_SRC_MAC_ADDRESS;
    memcpy(attr[1].value.mac, mac, sizeof(mac));

    attr[2].id = SAI_SWITCH_ATTR_SWITCH_STATE_CHANGE_NOTIFY;
    attr[2].value.ptr = reinterpret_cast<sai_pointer_t>(&on_switch_state_change);

    attr[3].id = SAI_SWITCH_ATTR_SHUTDOWN_REQUEST_NOTIFY;
    attr[3].value.ptr = reinterpret_cast<sai_pointer_t>(&on_shutdown_request);

    attr[4].id = SAI_SWITCH_ATTR_FDB_EVENT_NOTIFY;
    attr[4].value.ptr = reinterpret_cast<sai_pointer_t>(&on_fdb_event);

    attr[5].id = SAI_SWITCH_ATTR_PORT_STATE_CHANGE_NOTIFY;
    attr[5].value.ptr = reinterpret_cast<sai_pointer_t>(&on_port_state_change);

    sai_switch_api_t *sai_switch_api;
    int rv = sai_api_query(SAI_API_SWITCH, (void **) &sai_switch_api);
    sai_object_id_t gSwitchId;
    status = sai_switch_api->create_switch(&gSwitchId, attrSz, attr);

    if ((rv | status) == 0) {
        printf("SUCCESS! Broadcom SDK is now configured and ready.");
    }
}

extern "C" {
extern int sh_process_command(int u, char *c) __attribute__((weak));
}

int main(int argc, char *argv[]) {
    boot();

    std::cout << std::endl << "Type Broadcom Diag commands; run \"bsh\" to enter BCMLT, run \"cint\" to enter CINT." <<
            std::endl;
    std::string input;
    int unit = 0;
    while (true) {
        std::cout << "BCM." << unit << "> " << std::flush;
        std::getline(std::cin, input);
        if (!std::cin) break;

        const char *cstr = input.c_str();
        char *sh_input = new char[input.size() + 1];
        std::strcpy(sh_input, cstr);

        sh_process_command(unit, sh_input);
    }
}
