#!/bin/bash

echo 'Searching for SAI version...'

BRANCH="$(docker exec syncd cat /usr/lib/libsai.so.1.0 | strings | grep -m1 -oE 'SAI_[0-9]+\.[0-9]+\.[0-9]+_GA')"
VERSION="$(docker exec syncd cat /usr/lib/libsai.so.1.0 | strings | grep -m1 'BRCM SAI ver:' -C 1000 | grep -m1 -E '^[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+$')"

set -euo pipefail

if [[ -z "${BRANCH}" ]] || [[ -z "${VERSION}" ]]; then
        echo 'Didnt find anything :('
        exit 1
fi

echo "Detected branch ${BRANCH}, version ${VERSION}"

curl -L -O "https://packages.trafficmanager.net/public/sai/sai-broadcom/${BRANCH}/${VERSION}/xgs/libsaibcm_${VERSION}_amd64.deb"
curl -L -O "https://packages.trafficmanager.net/public/sai/sai-broadcom/${BRANCH}/${VERSION}/xgs/libsaibcm-dev_${VERSION}_amd64.deb"

echo ""
echo "Install with apt install ./libsai*.deb"
